<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('course_id');
			$table->timestamps();
			$table->string('course_name', 200);
			$table->binary('course_image');
			$table->string('course_category', 200);
			$table->text('course_overview');
			$table->string('course_requirements', 200);
			$table->string('course_duration', 200);
			$table->binary('video_overview');
			$table->string('course_status', 100);
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}