<?php

namespace App/models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'User';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Nom', 'prenom', 'numero_telephone', 'adresse_email', 'password');

    public function reservation()
    {
        return $this->hasMany('Visite');
    }

    public function ventes()
    {
        return $this->hasMany('Vente');
    }

    public function bienImmobilier()
    {
        return $this->hasMany('BienImmobilieres');
    }

    public function profile()
    {
        return $this->morphTo();
    }

    public function annonces()
    {
        return $this->hasMany('Annonce', 'client_id');
    }

    public function contacts()
    {
        return $this->hasMany('Contact');
    }

}