<?php

namespace App/models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BienImmobilieres extends Eloquent {

	protected $table = 'Biens_immobiliers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('titre', 'est_vendu', 'type_id');

	public function TypeBien()
	{
		return $this->hasOne('TypeBien', 'id');
	}

	public function Bien()
	{
		return $this->hasOne('Ville', 'id');
	}

	public function reservation()
	{
		return $this->hasMany('Visite');
	}

	public function ventes()
	{
		return $this->hasMany('Vente');
	}

	public function AttributsBien()
	{
		return $this->belongsToMany('Attributs', 'bien_immobiliere_attribut');
	}

	public function photos()
	{
		return $this->morphMany('\Image', 'imageable');
	}

}