<?php

namespace App/models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Courtier extends Eloquent {

	protected $table = 'Courtier';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('taux_commission');

	public function ventes()
	{
		return $this->hasMany('Vente');
	}

	public function user()
	{
		return $this->morphOne('User', 'profile');
	}

}