<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventTable extends Migration {

	public function up()
	{
		Schema::create('Event', function(Blueprint $table) {
			$table->string('id', 250);
			$table->timestamps();
			$table->integer('company_id')->unsigned();
			$table->string('banner', 250);
			$table->string('name', 250);
			$table->integer('location');
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->text('description');
			$table->integer('event_type');
			$table->text('keyword');
			$table->string('state', 20);
			$table->float('min_price');
			$table->float('max_price');
		});
	}

	public function down()
	{
		Schema::drop('Event');
	}
}