<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function favorites()
    {
        return $this->hasMany('Favourite');
    }

    public function ratings()
    {
        return $this->hasMany('Rating');
    }

    public function follows()
    {
        return $this->morphMany('Follow');
    }

    public function complaints()
    {
        return $this->hasMany('Complaint');
    }

    public function wallets()
    {
        return $this->morphMany('Wallet');
    }

    public function packages()
    {
        return $this->belongsToMany('Package');
    }

    public function ratings()
    {
        return $this->morphMany('Rating');
    }

}