<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('name');
			$table->string('image')->nullable();
			$table->string('country_code')->default('966');
			$table->string('iso2')->nullable();
			$table->string('iso3')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}