<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehicleTable extends Migration {

	public function up()
	{
		Schema::create('Vehicle', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->integer('user_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->timestamps();
			$table->string('description');
			$table->string('video_link');
			$table->string('contact_number');
			$table->string('email');
			$table->string('state');
		});
	}

	public function down()
	{
		Schema::drop('Vehicle');
	}
}