<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Content extends Model 
{

    protected $table = 'gooddreamer_content';
    public $timestamps = false;
    protected $fillable = array('id', 'uuid', 'content_name', 'content_sort', 'content_icon_path', 'content_icon_filename', 'content_slug', 'type', 'active', 'created_at', 'updated_at', 'deleted_at');
    protected $visible = array('id', 'uuid', 'content_name', 'content_sort', 'content_icon_path', 'content_icon_filename', 'content_slug', 'type', 'active', 'created_at', 'updated_at', 'deleted_at');

    public function item()
    {
        return $this->hasMany('ContentItem');
    }

    public function novel()
    {
        return $this->hasManyThrough('Novel', 'CollectionItem');
    }

}