<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class NovelTransaction extends Model 
{

    protected $table = 'gooddreamer_novel_transaction';
    public $timestamps = false;
    protected $fillable = array('id', 'user_id', 'novel_id', 'transaction_status', 'transaction_coin_value', 'created_at', 'updated_at');
    protected $visible = array('id', 'user_id', 'novel_id', 'transaction_status', 'transaction_coin_value', 'created_at', 'updated_at');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function novel()
    {
        return $this->belongsTo('Novel');
    }

    public function walletItem()
    {
        return $this->morphOne('WalletItem', 'reffable');
    }

}