<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDataAppVersionTable extends Migration {

	public function up()
	{
		Schema::create('data_app_version', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('version_code');
			$table->string('version_name', 255)->nullable();
			$table->string('version_message', 255)->nullable();
			$table->datetime('version_date');
			$table->tinyInteger('version_status');
			$table->tinyInteger('android_status');
			$table->tinyInteger('ios_status');
			$table->tinyInteger('active')->default('1');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('data_app_version');
	}
}