<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerPackageTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_package', function(Blueprint $table) {
			$table->integer('id', true);
			$table->string('uuid', 255);
			$table->string('package_name', 255)->nullable();
			$table->string('package_sub_name', 255)->nullable();
			$table->integer('package_price');
			$table->integer('package_coin_value');
			$table->integer('discount_value')->nullable();
			$table->float('discount_percentage')->nullable();
			$table->tinyInteger('publish')->default('0');
			$table->tinyInteger('active');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at');
			$table->datetime('published_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_package');
	}
}