<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerTransactionTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_transaction', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('user_id')->unsigned();
			$table->integer('package_id')->unsigned();
			$table->integer('payment_id')->unsigned()->nullable();
			$table->tinyInteger('transaction_status')->default('2');
			$table->integer('transaction_coin_value')->nullable();
			$table->integer('referral_user_id')->unsigned();
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_transaction');
	}
}