<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Operation extends Eloquent {

	protected $table = 'Operations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function commande()
	{
		return $this->belongsTo('App\Commande');
	}

	public function Team()
	{
		return $this->belongsTo('App\Team');
	}

	public function Secteure()
	{
		return $this->belongsTo('App\Secteure');
	}

	public function SousOpertaions()
	{
		return $this->hasMany('App\SousOperations');
	}

}