<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLostKidsTable extends Migration {

	public function up()
	{
		Schema::create('lost_kids', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->string('place')->nullable();
			$table->integer('age');
			$table->string('gender')->default('male');
			$table->string('image')->nullable();
			$table->integer('parent_id')->unsigned();
			$table->string('name')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('lost_kids');
	}
}