<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlaylistsTable extends Migration {

	public function up()
	{
		Schema::create('playlists', function(Blueprint $table) {
			$table->increments('id');
			$table->string('playlist_name', 200)->index();
			$table->text('playlist_description')->index();
			$table->integer('playlist_cover_photo_id');
			$table->integer('playlist_user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('playlists');
	}
}