<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContainerClient extends Model 
{

    protected $table = 'container_client';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'container_id');

    public function container()
    {
        return $this->belongsTo('Container', 'container_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function container_items()
    {
        return $this->hasMany('ContainerItem', 'container_client_id');
    }

}