<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContainerItemTable extends Migration {

	public function up()
	{
		Schema::create('container_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('container_client_id')->nullable();
			$table->string('type')->nullable();
			$table->double('length')->nullable();
			$table->double('width')->nullable();
			$table->double('height')->nullable();
			$table->integer('quantity')->nullable();
			$table->double('coeffecient')->nullable();
			$table->double('volume')->nullable();
			$table->double('price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('container_item');
	}
}