<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Store extends Model 
{

    protected $table = 'stores';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function categories()
    {
        return $this->belongsToMany('CategoryStore');
    }

    public function storeInfo()
    {
        return $this->hasOne('StoreInfo');
    }

    public function postRatings()
    {
        return $this->morphMany('PostRating');
    }

    public function images()
    {
        return $this->hasMany('StoreImage');
    }

    public function favoriteStores()
    {
        return $this->hasMany('FavoriteStore');
    }

    public function socials()
    {
        return $this->belongsToMany('StoreSocial');
    }

    public function posts()
    {
        return $this->morphMany('Post');
    }

    public function postMentions()
    {
        return $this->morphMany('Post');
    }

}