<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSocialAccountsTable extends Migration {

	public function up()
	{
		Schema::create('social_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('accountable');
			$table->enum('provider_type', array('apple'));
			$table->string('provider_account_id', 100);
			$table->string('email')->nullable();
			$table->text('access_token')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('social_accounts');
	}
}