<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar', 50)->nullable();
			$table->string('username');
			$table->string('country_code', 20);
			$table->string('phone', 50);
			$table->string('email', 100)->nullable();
			$table->decimal('lat')->nullable();
			$table->decimal('lng')->nullable();
			$table->decimal('map_desc')->nullable();
			$table->boolean('is_blocked')->default(0);
			$table->boolean('is_active')->default(1);
			$table->string('is_aproved')->default('pendeng,acepted,rejected');
			$table->bigInteger('ratings_count')->default('0');
			$table->bigInteger('ratings_avg')->default('0');
			$table->bigInteger('comments_count');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}