<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommunicationsTable extends Migration {

	public function up()
	{
		Schema::create('communications', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('is_active')->default(1);
			$table->string('type', 50)->default('url,phone,email');
			$table->string('name');
			$table->string('icon', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('communications');
	}
}