<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('username')->unique();
			$table->string('country_code', 5)->default('966');
			$table->string('phone', 50);
			$table->string('email')->unique();
			$table->string('password');
			$table->boolean('show_phone')->default(1);
			$table->decimal('lat');
			$table->decimal('lng');
			$table->text('map_desc');
			$table->bigInteger('ratings_count')->default('0');
			$table->decimal('ratings_avg')->default('0');
			$table->bigInteger('comments_count')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}