<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('slug')->unique();
			$table->boolean('status')->default(0);
			$table->bigInteger('parent_id')->unsigned();
			$table->integer('order')->nullable()->default('0');
			$table->string('icon')->nullable();
			$table->string('banner')->nullable();
			$table->boolean('show_in_navbar')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}