<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShipmentItemsTable extends Migration {

	public function up()
	{
		Schema::create('shipment_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('description')->nullable();
			$table->string('qty')->nullable();
			$table->string('weight')->nullable();
			$table->decimal('price')->default('0');
			$table->bigInteger('product_id')->unsigned();
			$table->bigInteger('order_item_id')->unsigned();
			$table->bigInteger('shipment_id')->unsigned();
			$table->json('additional')->nullable();
			$table->string('product_type')->nullable();
			$table->decimal('total_cost')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('shipment_items');
	}
}