<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->boolean('status')->default(0);
			$table->string('type');
			$table->string('avatar');
			$table->string('phone')->nullable();
			$table->timestamp('disabled_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}