<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCardsTable extends Migration {

	public function up()
	{
		Schema::create('cards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('client_id')->unsigned();
			$table->string('name', 255);
			$table->string('number', 255)->unique();
			$table->string('cvv', 255);
			$table->date('expiration_date');
			$table->boolean('default')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('cards');
	}
}