<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaginasTable extends Migration {

	public function up()
	{
		Schema::create('paginas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('menu_id')->unsigned()->nullable();
			$table->integer('categoria_id')->unsigned()->nullable();
			$table->string('nome', 255);
			$table->longText('texto');
			$table->datetimeTz('modificado_em');
			$table->integer('parente')->nullable();
			$table->text('link');
		});
	}

	public function down()
	{
		Schema::drop('paginas');
	}
}