<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('transaction_id')->nullable();
			$table->string('currency')->nullable();
			$table->decimal('amount', 8,2);
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}