<?php

namespace App\Models\Blog;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function posts()
	{
		return $this->hasMany('App\Models\Blog\Post', 'category_id');
	}

}