<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContratsTable extends Migration {

	public function up()
	{
		Schema::create('Contrats', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('filiale_id')->unsigned();
			$table->integer('fournisseur_id')->unsigned();
			$table->string('nature_contrat');
			$table->float('montant_da');
			$table->float('montant_devise');
			$table->enum('devise', array('EUR', 'USD'));
			$table->float('taux_conversion');
			$table->enum('nationalite_ent_etrangere', array('Algérienne', 'Allemande', 'Américaine', 'Anglaise', 'Autrichienne', 'Espagnole', 'Française', 'Italienne'));
			$table->string('observation');
			$table->date('date_contrat');
			$table->boolean('valide');
		});
	}

	public function down()
	{
		Schema::drop('Contrats');
	}
}