<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class UserInfo extends Model 
{

    protected $table = 'user_infos';
    public $timestamps = true;

    public function supporter()
    {
        return $this->hasOne('Supporter', 'user_id');
    }

    public function beneficiary()
    {
        return $this->hasOne('Beneficiary', 'user_id');
    }

    public function volunteer()
    {
        return $this->hasOne('Volunteer', 'user_id');
    }

    public function management()
    {
        return $this->hasOne('Management', 'user_id');
    }

    public function district()
    {
        return $this->belongsTo('District');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}