<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Volunteer extends Model 
{

    protected $table = 'volunteers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('note');

    public function user()
    {
        return $this->belongsTo('UserInfo');
    }

    public function logs()
    {
        return $this->hasMany('Volunteer_log', 'volunteer_id');
    }

}