<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_type_id');
			$table->string('email', 255);
			$table->string('password', 60);
			$table->string('remember_token', 100)->nullable();
			$table->string('is_active', 1);
			$table->string('sms_notification_active', 1)->default('n');
			$table->string('email_notification_active', 1)->default('n');
			$table->string('user_image', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}