<?php

namespace App\Employer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'company';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User', 'id');
	}

	public function posts()
	{
		return $this->hasMany('App/Employer\Post', 'company_id');
	}

}