<?php

namespace App\/Candidate;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Profile extends Eloquent {

	protected $table = 'candidate_profile';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function educations()
	{
		return $this->hasMany('EducationDetail', 'user_id');
	}

	public function experiences()
	{
		return $this->hasMany('ExperienceDetail', 'user_id');
	}

	public function refrences()
	{
		return $this->hasMany('ReferenceDetail', 'user_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'id');
	}

	public function certifications()
	{
		return $this->hasMany('Certificate', 'user_id');
	}

	public function trainigs()
	{
		return $this->hasMany('App\Training', 'user_id');
	}

	public function skills()
	{
		return $this->hasMany('App\Skill', 'user_id');
	}

	public function preference()
	{
		return $this->hasOne('App\Preference', 'user_id');
	}

	public function activities()
	{
		return $this->hasMany('\PostCanAc', 'candidate_id');
	}

}