<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostCandidateActivityTable extends Migration {

	public function up()
	{
		Schema::create('post_candidate_activity', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('post_id')->unsigned();
			$table->integer('candidate_id')->unsigned();
			$table->string('status', 20)->nullable()->default('open');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('post_candidate_activity');
	}
}