<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePreferenceDetailTable extends Migration {

	public function up()
	{
		Schema::create('preference_detail', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('user_id')->unsigned();
			$table->string('work_type', 100);
			$table->string('work_time', 100);
			$table->string('work_travel', 100);
			$table->string('work_relocate', 1);
			$table->string('work_hours', 20)->nullable();
			$table->string('work_location', 100);
			$table->string('work_min_pay', 100);
			$table->text('work_comments')->nullable();
			$table->string('cv_permission', 1)->default('y');
			$table->text('general_comments')->nullable();
			$table->string('ielts_exam_status', 1)->nullable();
			$table->string('ielts_exam_score', 10)->nullable();
			$table->string('toefl_exam_status', 1)->nullable();
			$table->string('toefl_exam_score', 10)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('preference_detail');
	}
}