<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserBankAccountTable extends Migration {

	public function up()
	{
		Schema::create('user_bank_account', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('bank_name', 100);
			$table->string('iban', 34);
			$table->string('fullname', 100);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_bank_account');
	}
}