<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserWalletLogTable extends Migration {

	public function up()
	{
		Schema::create('user_wallet_log', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->decimal('balance_before', 14,4)->default('0');
			$table->decimal('balance_after', 14,4)->default('0');
			$table->enum('balance_type', array(''));
			$table->enum('source', array(''));
		});
	}

	public function down()
	{
		Schema::drop('user_wallet_log');
	}
}