<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserWalletTable extends Migration {

	public function up()
	{
		Schema::create('user_wallet', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->decimal('balance', 14,4)->default('0');
			$table->decimal('gift_balance', 14,4)->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_wallet');
	}
}