<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function productCategory()
	{
		return $this->belongsTo('ProductCategory');
	}

	public function productKeys()
	{
		return $this->hasMany('ProductItem', 'product_id');
	}

	public function Image()
	{
		return $this->hasMany('ProductImage', 'product_id');
	}

}