<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function followings()
	{
		return $this->hasMany('UserRelation', 'follower_user_id')->withTimestamps();
	}

	public function followers()
	{
		return $this->hasMany('UserRelation', 'following_user_id');
	}

	public function wallet()
	{
		return $this->hasOne('UserWallet', 'user_id');
	}

	public function walletLogs()
	{
		return $this->hasMany('UserWalletLog', 'user_id');
	}

	public function bankAccounts()
	{
		return $this->hasMany('UserBankAccount', 'user_id');
	}

	public function visitors()
	{
		return $this->hasMany('UserVisitor');
	}

}