<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HouseWorker extends Model 
{

    protected $table = 'house_worker';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('house_id', 'name_en', 'name_ar', 'description_en', 'description_ar', 'position_id');

    public function house()
    {
        return $this->belongsTo('House', 'house_id');
    }

    public function position()
    {
        return $this->belongsTo('Position', 'position_id');
    }

}