<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHouseRequirementTable extends Migration {

	public function up()
	{
		Schema::create('house_requirement', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('house_id')->nullable();
			$table->integer('orphan_id')->nullable();
			$table->enum('type', array('general', 'individual'))->nullable();
			$table->integer('store_id')->nullable();
			$table->integer('product_id')->nullable();
			$table->integer('category_id')->nullable();
			$table->decimal('total_price', 10,2)->nullable();
			$table->integer('quantity')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('house_requirement');
	}
}