<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserGoalTable extends Migration {

	public function up()
	{
		Schema::create('user_goal', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->date('from_date')->nullable();
			$table->date('to_date')->nullable();
			$table->decimal('amount', 10,2)->nullable();
			$table->decimal('general_requirements_amount', 10,2)->nullable();
			$table->decimal('individual_requirement_amount', 10,2)->nullable();
			$table->decimal('service_amount', 10,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_goal');
	}
}