<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHouseTable extends Migration {

	public function up()
	{
		Schema::create('house', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->string('name_en', 255)->nullable();
			$table->string('name_ar', 255)->nullable();
			$table->string('phone', 20)->nullable();
			$table->string('address_en', 255)->nullable();
			$table->string('address_ar', 255)->nullable();
			$table->date('establishment_date')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->integer('number_of_children')->nullable();
			$table->decimal('average_age', 3,1)->nullable();
			$table->text('activities')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('house');
	}
}