<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HouseWorker extends Eloquent {

	protected $table = 'house_worker';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('house_id', 'name_en', 'name_ar', 'description_en', 'description_ar', 'position_id');

	public function house()
	{
		return $this->belongsTo('House', 'house_id');
	}

	public function position()
	{
		return $this->belongsTo('Position', 'position_id');
	}

}