<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Orphan extends Eloquent {

	protected $table = 'orphan';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('house_id', 'name_en', 'name_ar', 'birth_date', 'birth_place', 'orphan_condition', 'parents_condition', 'live_with_family', 'colleagues');

	public function house()
	{
		return $this->belongsTo('House', 'house_id');
	}

	public function requirements()
	{
		return $this->hasMany('HouseRequirement', 'orphan_id');
	}

}