<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrphanFamily extends Eloquent {

	protected $table = 'orphan_family';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('orphan_id', 'name_en', 'name_ar', 'relative_status');

	public function orphan()
	{
		return $this->belongsTo('Orphan', 'orphan_id');
	}

}